## Changes since 3.1.13

- New icon/logo

  - SVG (scalable), made with Inkscape

- Major changes in Main Window

  - Add "Right Panel" to see user events and plugins' text

    - In Persian, it's located on the left, so it's translated to "Left Panel"

  - You can still disable Right Panel, and enable Events and Plugins below the calendar (See animated gifs below)

  - Re-design the layout of "Customize" window

    - Use a mix of vertical and horizontal layout for root widgets (first page of "Customize")
    - Allows Customize window to be smaller and work in smaller screens
    - Avoid automatically resizing Customize window
    - Improves the UX, and allows better use of space
    - Pagination similar to familiar UX of tablets and smart phones
    - See animated gifs below

  - Allow freely resizing main window

    - In previous versions user could not resize the window vertically
      - User had to change the height of Month/Week/Day Calendars in Customize window
    - Month/Week/Day Calendars are expanded when window is resized
    - **Height** option is no longer needed and removed from Month/Week/Day Calendars

  - Rewrite Events view widget (below calendar and in Right Panel), with some new features

    - It was a GtkHBox with many children, not it's only one GtkTreeView
    - Allow customizing separator between summary and decription of event
    - Add "Copy Event Text" item to right-click menu

- Re-design Preferences window and Customize window

  - Split everything into multiple pages (using Gtk.Stack)
  - Makes the UX much better
  - Organizes the options better
  - Makes the window smaller, and compatible with smaller screens
  - Becomes more similar to touchscreen operating systems
  - Can switch to parent page by pressing Backspace (equal to "Back" button)
  - See animated gifs below

- Add Day Calendar Window, aka "Desktop Widget"

  - To use as a desktop widget, and alternative for status icon
  - Plus the Customize window for it
  - Add option to Preferences:
    General -> \[ \] Open desktop widget on start
  - See animated gifs below

- More features and options for Day Calendar as part of Main Window

  - Most of the code is shared with Desktop Widget
  - Options of Customize window are mostly the same, but values are independent
    - i.e. changing options of one does not effect the other
  - New features (both in main window desktop widget)
    - Allow enabling week day name
      - With "Abbreviate" and "Uppercase" checkbox options
    - Show buttons to go to previous day, today and next day

- Time Line: Features, improvements and refactoring

  - Add Preferences for Time Line
    - With a lot of options, see animated gifs below
  - Add 3 buttons (left, right, stop) for controlling movement in time
  - Fix/improve animation
  - Minor features / improvements:
    - Show helper line on button-press when moving/resizing event box
    - Add a zoom icon that opens to menu to jump to specific round zoom levels

- Window Controller: switch to svg, and add more options

  - Allow customizing the size of icons (since svg is scalable)
  - Allow customizing border (around buttons) and spacing (between buttons)
  - Add a button to show/hide Right Panel

- Replace most of `.png` icons with scalabale `.svg` icons

  - Add `.svg` icons for some menu items and button without icon
  - Add support for svg images in some parts of program that lacked support

- Minor features and improvements

  - Month Calendar: allow disabling day numbers of non-primary cal types
  - Event Manager -> Import Events -> Switch to Stack (like Customize)
  - Rename sub-menu "Add to" to "Add Event to" in day right-click menu
  - Some optimization in Week Calendar
  - Preferences -> Appearance -> Status Icon -> click on image selector button
    - Add preview in File Chooser dialog
  - Replace "Font Family" chooser widget
    - It was a ComboBox, not it opens a dialog that allows search on type and shows preview
    - Used in Week Calendar customize options, and Status Icon preferences
  - WeekCal: add Customize option to enable "Row Gradient" (as replacement for grid lines)

- Switch away from Gtk's deprecated APIs and fix deprecation warnings

  - Widget constructor calls with non-keyword arguments
  - Gtk stock items (switch to icon names)
  - `height-request` and `width-request` properties
  - `Gtk.HButtonBox`
  - `Gtk.FontButton.get_font_name`
  - `Gdk.Window.get_pointer`
  - `Gdk.Window.cairo_create`
  - `Gtk.Label.set_alignment`
  - `Gtk.Dialog(buttons=...)`
  - `Gtk.FileChooserButton.new_with_dialog`
  - `ResourceWarning: unclosed file ...` on `open(...).read()` and `open(...).write(...)`

- Changes in package dependencies:

  - Drop support for `python3.5`
    - Now only support `python3.6` and `python3.7`
  - Depend on `python3-gi >= 3.24`
    - Because Gtk.FontChooser.set_level is added in version 3.24
  - Optional dependency to `gtksource-4` / `gtksourceview4`
  - Optional dependency to `ntpdate`
  - Optional dependency to `python3-pygit2`

- Improvements in install scripts:

  - Move all scripts to [distro](./distro/) directory

    - Create symbolic links (to `install-*`) to keep compatibility

  - Add `install-auto.sh` which automatically detects distribution

  - Debian:

    - Add `postrm` script
      - to completely clean up `/usr/share/starcal3` after package removal
    - Use `apt` instead of `gdebi` to install the package
      - Fallback to `dpkg -i` if `apt` was not found
      - If `dpkg -i` failed, run `apt-get -f install` to fix broken dependencies

  - Add installers for FreeBSD, MidnightBSD, Alma Linux

  - Update install-windows.bat

- Switch from `%`-formatting to f-strings (added in `python3.6`)

  - Use `str.format` for localized strings

- Switch to Python's `logging` completely (no more `print`)

- Add types and comments

- Refactoring, cleaning, removing some legacy code and PEP-8 fixes

- Add compatibilty with official Islamic calendar 1423 - 1426
