<?php
/*-----------------------------------------------------------------------------------*/
/* CoLabsThemes Theme Version */
/*-----------------------------------------------------------------------------------*/
function colabs_version_init() {

    $colabs_framework_version = '1.4.4';

    if ( get_option( 'colabs_framework_version' ) != $colabs_framework_version ) {
    	update_option( 'colabs_framework_version', $colabs_framework_version );
    }

}

add_action( 'init', 'colabs_version_init', 10 );

function colabs_version(){

    $theme_data = wp_get_theme();
    $theme_version = $theme_data->Version;
    $colabs_framework_version = get_option( 'colabs_framework_version' );

	echo "\n<!-- Theme version -->\n";
    echo '<meta name="generator" content="'. esc_attr( get_option( 'colabs_themename' ) ) . ' ' . $theme_version . '" />' ."\n";
    echo '<meta name="generator" content="CoLabsFramework '. esc_attr( $colabs_framework_version ) .'" />' ."\n";

}

// Add or remove Generator meta tags
if ( get_option( 'framework_colabs_disable_generator' ) == 'true' ) {
	remove_action( 'wp_head',  'wp_generator' );
} else {
	add_action( 'wp_head', 'colabs_version', 10 );
}

// Define directory constants
define('COLABS_FRAMEWORK', get_template_directory_uri() . '/functions');
define('COLABS_FRAMEWORK_CSS', COLABS_FRAMEWORK . '/css');
define('COLABS_FRAMEWORK_IMAGES', COLABS_FRAMEWORK . '/images');
define('COLABS_FRAMEWORK_JS', COLABS_FRAMEWORK . '/js');

define('COLABS_FUNCTIONS', get_template_directory_uri() . '/includes');
define('COLABS_FUNCTIONS_CSS', COLABS_FUNCTIONS . '/css');
define('COLABS_FUNCTIONS_JS', COLABS_FUNCTIONS . '/js');
define('COLABS_FUNCTIONS_WIDGETS', COLABS_FUNCTIONS . '/widgets');


/*-----------------------------------------------------------------------------------*/
/* Load the required Admin Panel Files */
/*-----------------------------------------------------------------------------------*/
$functions_path = get_template_directory() . '/functions/';
require_once ($functions_path . 'admin-functions.php');				// Custom functions and plugins
require_once ($functions_path . 'admin-setup.php');					// Options panel variables and functions
require_once ($functions_path . 'admin-custom.php');                // Custom fields 
require_once ($functions_path . 'admin-interface.php');				// Admin Interfaces (options,framework, seo)
require_once ($functions_path . 'admin-interface-functions.php');	// Admin Interface - Functions
require_once ($functions_path . 'admin-framework-settings.php' );	// Framework Settings
require_once ($functions_path . 'admin-dashboard.php' );            // Dashboard Settings
require_once ($functions_path . 'admin-layout.php' );               // Layout Settings
require_once ($functions_path . 'admin-seo.php');					// Admin Panel SEO controls
require_once ($functions_path . 'admin-medialibrary-uploader.php'); // Admin Panel Media Library Uploader Functions // 2011-28-05.
require_once ($functions_path . 'admin-hooks.php');					// Definition of CoLabsHooks
require_once ($functions_path . 'admin-shortcode-generator.php'); 	// Admin Panel Shortcode generator // 2011-05-27.
require_once ($functions_path . 'admin-shortcodes.php');			// CoLabs Shortcodes
/*-----------------------------------------------------------------------------------*/
/* Load the required action */
/*-----------------------------------------------------------------------------------*/

?>