/*
 * DEW - Multi Purpose Wordpress Theme.
 *
 * Copyright (c) 2013 FÂ²
 * 
 * Main Javascript
 */
/******************************************************************************************************************************
MENU
*******************************************************************************************************************************/
(function($) { 
    "use strict";
        $("ul.sf-menu").superfish(); 
        $('ul.sf-menu > li > a.sf-with-ul').parent('li').addClass('sf-ul');

        var navigation = responsiveNav("#menu", { // Selector: The ID of the wrapper
              animate: true, // Boolean: Use CSS3 transitions, true or false
              transition: 400, // Integer: Speed of the transition, in milliseconds
              label: '<span class="icon">&#xe0f4;</span>', // String: Label for the navigation toggle,  
              insert: "before"
            });
})(jQuery); 
/******************************************************************************************************************************
SEARCH
*******************************************************************************************************************************/
(function($) {
    "use strict";
    $("header .sb-icon-search").click(function () {
        
        $("header .sb-search-input,header .sb-search-triangle").fadeToggle();

        return false;
    });
})(jQuery);
/******************************************************************************************************************************
TWITTER
*******************************************************************************************************************************/
(function($) {
    "use strict";
    $('.tweets').tweet({
          template: "{text} {time}",
          //li_class: " ",
          twitter_api_url: 'twitter/proxy/twitter_proxy.php'
      });
})(jQuery);
/******************************************************************************************************************************
FITVIDS
*******************************************************************************************************************************/
(function($) {
    "use strict";
        $(".video-wrapper").fitVids({ customSelector: "iframe[src^='http://www.dailymotion.com']"});
})(jQuery);
/******************************************************************************************************************************
SLIDER
*******************************************************************************************************************************/
(function($) {
    "use strict";
    $("#slider").revolution(
    {
            delay:9000,
            startheight:450,
            startwidth:890,

            thumbWidth:100,
            thumbHeight:50,
            thumbAmount:5,

            onHoverStop:"on",
            hideThumbs:200,
            navigationType:"bullet",
            navigationStyle:"round",
            navigationArrows:"verticalcentered",

            touchenabled:"on",

            navOffsetHorizontal:0,
            navOffsetVertical:80,
            shadow:undefined,
            fullWidth:"on",
            fullScreen:"on"
    });
})(jQuery);
/******************************************************************************************************************************
COMMING SOON PAGE
*******************************************************************************************************************************/
(function($) {
    /**
    * Set your date here  (YEAR, MONTH (0 for January/11 for December), DAY, HOUR, MINUTE, SECOND)
    * according to the GMT+0 Timezone
    **/
    var launch = new Date(2014, 06, 14, 11, 00);
    /**
    * The script
    **/
    var message = $('#message');
    var days = $('#days');
    var hours = $('#hours');
    var minutes = $('#minutes');
    var seconds = $('#seconds');
    
    setDate();
    function setDate(){
        var now = new Date();
        if( launch < now ){
            days.html('<h1>0</H1><p>Day</p>');
            hours.html('<h1>0</h1><p>Hour</p>');
            minutes.html('<h1>0</h1><p>Minute</p>');
            seconds.html('<h1>0</h1><p>Second</p>');
            message.html('We are truly sorry for our delay, but our website is coming...');
        }
        else{
            var s = -now.getTimezoneOffset()*60 + (launch.getTime() - now.getTime())/1000;
            var d = Math.floor(s/86400);
            days.html('<h1>'+d+'</h1><p>Day'+(d>1?'s':''),'</p>');
            s -= d*86400;

            var h = Math.floor(s/3600);
            hours.html('<h1>'+h+'</h1><p>Hour'+(h>1?'s':''),'</p>');
            s -= h*3600;

            var m = Math.floor(s/60);
            minutes.html('<h1>'+m+'</h1><p>Minute'+(m>1?'s':''),'</p>');

            s = Math.floor(s-m*60);
            seconds.html('<h1>'+s+'</h1><p>Second'+(s>1?'s':''),'</p>');
            setTimeout(setDate, 1000);

            message.html('Welcome ! Unfortunately, we are not ready now. But, the launch day is coming !');
        }
    }
})(jQuery);
/******************************************************************************************************************************
LIGHTBOX
*******************************************************************************************************************************/
(function($) {
    "use strict";
        $(".lightbox").mouseover(function() {
          $(this).children('div').fadeIn(200);
        }).mouseleave(function() {
            $(this).children('div').fadeOut(200);
          });
        $('[data-toggle=lightbox]').nivoLightbox({
            effect: 'slideUp', // The effect to use when showing the lightbox
            theme: 'default', // The lightbox theme to use
            keyboardNav: true, // Enable/Disable keyboard navigation (left/right/escape)
            onInit: function(){}, // Callback when lightbox has loaded
            beforeShowLightbox: function(){}, // Callback before the lightbox is shown
            afterShowLightbox: function(lightbox){}, // Callback after the lightbox is shown
            beforeHideLightbox: function(){}, // Callback before the lightbox is hidden
            afterHideLightbox: function(){}, // Callback after the lightbox is hidden
            onPrev: function(element){}, // Callback when the lightbox gallery goes to previous item
            onNext: function(element){}, // Callback when the lightbox gallery goes to next item
            errorMessage: 'The requested content cannot be loaded. Please try again later.' // Error message when content can't be loaded
        });
})(jQuery);
/******************************************************************************************************************************
ISOTOPE
*******************************************************************************************************************************/
(function($) {
    "use strict";
        // cache container
        var $container = $('#portfolio-container');
        // initialize isotope
        // filter items when filter link is clicked
        $('.filters a').click(function(){
            var selector = $(this).attr('data-filter');
            $container.isotope({ filter: selector });
            return false;
        });
})(jQuery);
/******************************************************************************************************************************
BOOTSTRAP
*******************************************************************************************************************************/
(function($) {
    "use strict";
        $("[data-toggle=collapse]").collapse();
        $('[data-toggle=tooltip]').tooltip();
        $('#MyTab a').click(function (e) {
          e.preventDefault()
          $(this).tab('show')
        });
})(jQuery);
/******************************************************************************************************************************
FOOTER OPENING
*******************************************************************************************************************************/
(function($) {
    "use strict";
    $('[data-toggle=tooltip]').tooltip();
    $('#footer-opening').click(function(){
            $('#footer').slideToggle();
            $("html, body").animate({ scrollTop: $(document).height() }, "slow");
            return false;
    });
})(jQuery);

/******************************************************************************************************************************
FLICKR
*******************************************************************************************************************************/
(function($) {
    "use strict";
    $('.flickr-feed').flickrfeed('79008272@N08', '', {
        limit: 8,
        date: false,
        header: false,
        title: false
    });
})(jQuery);
/******************************************************************************************************************************
DRIBBBLE
*******************************************************************************************************************************/
(function($) {
    "use strict";
    $.jribbble.getShotsByPlayerId('kailoon', function (playerShots) {
        var html = [];

        $.each(playerShots.shots, function (i, shot) {
            html.push('<li><a href="' + shot.url + '" title="' + shot.title + '">');
            html.push('<img src="' + shot.image_teaser_url + '" ');
            html.push('alt="' + shot.title + '"></a></li>');
        });

        $('.shotsByPlayerId').html(html.join(''));
    }, {page: 1, per_page: 8});
})(jQuery);