- **Add support for Python 3.7**

- **Drop support for Python 3.4** or older versions

- **Features and improvements in events**

  - Add Event History feature to Event Manager dialog
    - Right-click on an event and select History
  - Add \[x\]Timezone to event group, to use as event's default
  - Add "Enable All Groups" and "Disable All Groups" to "Edit" in menu bar
  - Main window -> Events text -> right click -> add "Move to" submenu -> "Disabled" submenu
  - Allow editing events by right-click on a day in Week/Month Calendar
  - Show custom title of event trash in confirmation dialogs
  - Add UUID to groups and events (will be useful later)
  - Improvemens in Event Editor dialog

- **Bug fixes in Event Manager dialog**

  - Event Editor dialog: Fix not expanding widgets after Type is changed
  - Fix not saving event group list after creating groups automatically in the first run
  - Fix showing current time as Last Modified time of events
  - Fix showing duplicate events
    - When event was added from main window, and Event Manager was opened twice

  * Minor fix: menu bar: View: \[x\] Show \_Description (underline before D)

- **Other bug fixes in events**

  - Fix event group type "VCS Repository (Tags)"
  - Fix and complete event rule conflicts

- Features, improvements and few bug fixes in **Week Calendar**

  - Add "Moon Status" column, shows the shape of moon
  - Add support for left and right keys (next/previous week)
  - Improve options of (Customize -> Week Cal -> Events Text), allow changing the color of past events
  - Add \[ \]Expand check box to some Week Calendar columns in Customize dialog
  - Bug fix: clicking on "Days of Month" column triggered moving window

- Fix small bugs and make improvements in **Customize dialog**

- Improvement in **Preferences** window

  - add Regional tab, move most of Advanced tab into it
  - Fix hotkeys

- Feature and improvement in **Season Progress Bar**

  - Fix now showing text (season name) since migrating to Gtk3.
  - Fix the font and color of text as well (Gtk3's default does not match the application)
  - Add support for Southern Hemisphere

- Add **Year Progress Bar** widget/row to main window

- Feature and improvement in **Day Info** dialog

  - Show Julian Day Number
  - Make all dates selectable

- Features and improvements on **Year Wheel** window

  - Show year numbers
  - Add 3 buttons: close/quit, home, resize
  - Handle Home and Escape keys
  - Add Year Wheel to menus

- **Bug fixes in Windows** operating system:

  - Specify encoding=UTF-8 when opening files
  - Fix a few NameErrors exceptions in windows
  - Fix Status Icon menu not working in windows

- Bug fixes and improvements in **install scripts**

  - Specify supported Python versions
  - Add missing dependency python3-cairo to install-suse and install-fedora
  - Add "set -e" to beginning of all install\* script to exit if any command failed
  - install-debian: when dgebi gives "A later version is already installed", try again with dpkg -i
  - install-suse: fix error "Empty tag: Recommends:"
  - fix install-fedora: package created but not installed
  - install-fedora: turn off the brp-python-bytecompile automagic
  - install-fedora: add BuildRequires
  - install: remove \*.tar.gz from the package directory
  - install: allow passing `--python python3.x` option
  - Add install-windows.bat and install-pip scripts

- Changes in in **Time Line** window

  - Improve/rewrite the algorithm for rendering events in Time Line window, and add tests
  - Fix out of range exception in scale of thausands of years

- Fixes in **Adjust System Time** dialog

  - Fix bad timer scheduling in Adjust System Time dialog
  - Add support for `sudo --askpass` in the lack of gksu/gksudo

- Improvemens in **About** dialog

  - Show accurate git version (from git describe --tags)
  - Show nicer (bold) version

- Other improvements and bug fixes

  - Fix custom widget used for date and/or time inputs

    - Rewrite without using GtkSpinButton which was very troubling

  - Day Calendar: implement right click menu

  - Fix logging, it was not working since 3.0.0

  - Add dark-violet status icon

  - Fix/update time zone tree

  - If run with python2, print "Run this script with Python 3.x" in stderr, instead of SyntaxError

  - Change shebang lines to "#!/usr/bin/env python3" for all python files

  - Catch exceptions and show them graphically in Error Dialog, by adding file ui_gtk/starcal-main.py

  - Improve status icon menu position

  - Use ujson module if exists if it's installed

    - Because it's faster tham json module

  - Sort keys in json config files

- Changes for Iranian official calendar:

  - Update hijri months based on Iranian official calendar for 1398
  - Show a message dialog when Hijri months are expired (check on startup and date-change)

  * Update Iran's plugins based on Iranian official calendar 1398

- Cleaning, refactoring and comments

  - Change indentation from spaces to tabs
  - Replace single quotes with double quotes
  - Add some type annotations and some comments
  - Cleanings, PEP-8 style fixes, and remove ununsed codes

- **Changes in dependencies**

  - Remove *python3-bson* or *python3-pymongo* from dependencies
    - Ship bson library with StarCalendar
  - Change *python3-dateutil* from optional dependency to a dependency
    - Because we switched to `dateutil.tz` for timezone
  - Add *python3-requests* to dependencies
  - Add *python3-ujson* as optional dependency
