﻿<%@ Control Language="C#" AutoEventWireup="True" CodeBehind="Settings.ascx.cs" Inherits="TanLD.Modules.SnowFall.Settings" %>
<%@ Register TagPrefix="dnn" TagName="Label" Src="~/controls/LabelControl.ascx" %>
<%@ Register TagPrefix="dnn" TagName="URL" Src="~/controls/URLControl.ascx" %>

<table cellspacing="5" cellpadding="0" width="600">   
    <tr>
        <td colspan="2"><h2>SnowFall settings</h2></td>
    </tr>
    <tr>
        <td class="SubHead" style="width: 150px" valign="top">
            <dnn:Label ID="plFlakeCount" runat="server" ControlName="txtFlakeCount" Suffix=":"></dnn:Label>
        </td>
        <td>
            <asp:TextBox ID="txtFlakeCount" runat="server" Width="100px"
                CssClass="NormalTextBox"></asp:TextBox>
            <asp:CompareValidator ID="valFlakeCount" resourcekey="FlakeCount.ErrorMessage" runat="server"
                CssClass="NormalRed" ControlToValidate="txtFlakeCount" ErrorMessage="<br />Flake Count must be an integer value."
                Display="Dynamic" Type="Integer" Operator="DataTypeCheck"></asp:CompareValidator>
        </td>
    </tr>   
    
    <tr>
        <td class="SubHead" valign="top">
            <dnn:Label ID="plMinSize" runat="server" ControlName="txtMinSize" Suffix=":"></dnn:Label>
        </td>
        <td>
            <asp:TextBox ID="txtMinSize" runat="server" Width="100px"
                CssClass="NormalTextBox"></asp:TextBox>
            <asp:CompareValidator ID="CompareValidator1" resourcekey="MinSize.ErrorMessage" runat="server"
                CssClass="NormalRed" ControlToValidate="txtMinSize" ErrorMessage="<br />Min Size must be an integer value."
                Display="Dynamic" Type="Integer" Operator="DataTypeCheck"></asp:CompareValidator>
        </td>
    </tr>  

    <tr>
        <td class="SubHead" valign="top">
            <dnn:Label ID="plMaxSize" runat="server" ControlName="txtMaxSize" Suffix=":"></dnn:Label>
        </td>
        <td>
            <asp:TextBox ID="txtMaxSize" runat="server" Width="100px"
                CssClass="NormalTextBox"></asp:TextBox>
            <asp:CompareValidator ID="CompareValidator2" resourcekey="MaxSize.ErrorMessage" runat="server"
                CssClass="NormalRed" ControlToValidate="txtMaxSize" ErrorMessage="<br />Max Size must be an integer value."
                Display="Dynamic" Type="Integer" Operator="DataTypeCheck"></asp:CompareValidator>
        </td>
    </tr>  

    <tr>
        <td class="SubHead" valign="top">
            <dnn:Label ID="plMinSpeed" runat="server" ControlName="txtMinSpeed" Suffix=":"></dnn:Label>
        </td>
        <td>
            <asp:TextBox ID="txtMinSpeed" runat="server" Width="100px"
                CssClass="NormalTextBox"></asp:TextBox>
            <asp:CompareValidator ID="CompareValidator3" resourcekey="MinSpeed.ErrorMessage" runat="server"
                CssClass="NormalRed" ControlToValidate="txtMinSpeed" ErrorMessage="<br />Min Speed must be an integer value."
                Display="Dynamic" Type="Integer" Operator="DataTypeCheck"></asp:CompareValidator>
        </td>
    </tr>  

    <tr>
        <td class="SubHead" valign="top">
            <dnn:Label ID="plMaxSpeed" runat="server" ControlName="txtMaxSpeed" Suffix=":"></dnn:Label>
        </td>
        <td>
            <asp:TextBox ID="txtMaxSpeed" runat="server" Width="100px"
                CssClass="NormalTextBox"></asp:TextBox>
            <asp:CompareValidator ID="CompareValidator4" resourcekey="MaxSpeed.ErrorMessage" runat="server"
                CssClass="NormalRed" ControlToValidate="txtMaxSpeed" ErrorMessage="<br />Max Speed must be an integer value."
                Display="Dynamic" Type="Integer" Operator="DataTypeCheck"></asp:CompareValidator>
        </td>
    </tr>  
    <tr>
        <td class="SubHead" valign="top">
            <dnn:Label ID="plShadow" runat="server" ControlName="chkShadow" Suffix=":"></dnn:Label>
        </td>
        <td>
            <asp:CheckBox ID="chkShadow" runat="server" />
        </td>
    </tr> 
    <tr>
        <td class="SubHead" valign="top">
            <dnn:Label ID="plIsActive" runat="server" ControlName="chkIsActive" Suffix=":"></dnn:Label>
        </td>
        <td>
            <asp:CheckBox ID="chkIsActive" runat="server" />
        </td>
    </tr> 

    <tr>
        <td colspan="2"><hr /></td>
    </tr>
    <tr>
        <td colspan="2"><h2>Popup Image Settings</h2></td>
    </tr>
    <tr>
        <td class="SubHead" valign="top">
            <dnn:Label ID="plImage" runat="server" ControlName="urlImage" Suffix=":"></dnn:Label>
        </td>
        <td>
            <dnn:URL ID="urlImage" runat="server" Width="300" Required="False" ShowTabs="False"
                ShowFiles="True" ShowUrls="True" ShowLog="False" ShowNone="true" ShowNewWindow="False"
                ShowTrack="False" />
        </td>
    </tr>
    
    <tr>
        <td class="SubHead" valign="top">
            <dnn:Label ID="plURL" runat="server" ControlName="ctlURL" Suffix=":"></dnn:Label>
        </td>
        <td>
            <dnn:URL ID="ctlURL" runat="server" Width="225" ShowLog="False" ShowNone="true" ShowNewWindow="False"
                ShowTrack="False" />
        </td>
    </tr>    
    <tr>
        <td colspan="2">
            <br />
        </td>
    </tr>
    <tr>
        <td class="SubHead">
            <dnn:Label ID="plSidePosition" Suffix=":" ControlName="cboSidePosition" runat="server">
            </dnn:Label>
        </td>
        <td>
            <asp:DropDownList ID="cboSidePosition" runat="server">
                <asp:ListItem Text="Left" Value="left" Selected="True"></asp:ListItem>
                <asp:ListItem Text="Right" Value="right"></asp:ListItem>
                <asp:ListItem Text="Top" Value="top"></asp:ListItem>
                <asp:ListItem Text="Bottom" Value="bottom"></asp:ListItem>
            </asp:DropDownList>
        </td>
    </tr>
   
    <tr>
        <td class="SubHead">
            <dnn:Label ID="plShowAfter" runat="server" ControlName="txtShowAfter" Suffix=":">
            </dnn:Label>
        </td>
        <td>
            <asp:TextBox ID="txtShowAfter" runat="server" Width="100px"
                CssClass="NormalTextBox"></asp:TextBox>
            <asp:CompareValidator ID="valShowAfter" resourcekey="ShowAfter.ErrorMessage" runat="server"
                CssClass="NormalRed" ControlToValidate="txtShowAfter" ErrorMessage="<br>Show After must be an integer value."
                Display="Dynamic" Type="Integer" Operator="DataTypeCheck"></asp:CompareValidator>
        </td>
    </tr>
    <tr>
        <td class="SubHead">
            <dnn:Label ID="plDelay" runat="server" ControlName="txtDelay" Suffix=":">
            </dnn:Label>
        </td>
        <td>
            <asp:TextBox ID="txtDelay" runat="server" Width="100px"
                CssClass="NormalTextBox"></asp:TextBox>
            <asp:CompareValidator ID="valDelay" resourcekey="Delay.ErrorMessage" runat="server"
                CssClass="NormalRed" ControlToValidate="txtDelay" ErrorMessage="<br>Delay must be an integer value."
                Display="Dynamic" Type="Integer" Operator="DataTypeCheck"></asp:CompareValidator>
        </td>
    </tr>
    <tr>
        <td class="SubHead">
            <dnn:Label ID="plSpeed" runat="server" ControlName="txtSpeed" Suffix=":">
            </dnn:Label>
        </td>
        <td>
            <asp:TextBox ID="txtSpeed" runat="server" Width="100px"
                CssClass="NormalTextBox"></asp:TextBox>
            <asp:CompareValidator ID="valSpeed" resourcekey="Speed.ErrorMessage" runat="server"
                CssClass="NormalRed" ControlToValidate="txtSpeed" ErrorMessage="<br>Speed must be an integer value."
                Display="Dynamic" Type="Integer" Operator="DataTypeCheck"></asp:CompareValidator>
        </td>

    </tr>
    <tr>
        <td class="SubHead" valign="top">
            <dnn:Label ID="plIsPopupActive" runat="server" ControlName="chkPopupActive" Suffix=":"></dnn:Label>
        </td>
        <td>
            <asp:CheckBox ID="chkPopupActive" runat="server" />
        </td>
    </tr> 
</table>

