<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="EditQuizQuestion.ascx.cs" Inherits="ICG.Modules.DnnQuiz.EditQuizQuestion" %>
<%@ Register TagPrefix="dnn" TagName="Label" Src="~/controls/labelcontrol.ascx" %>
<%@ Register TagPrefix="dnn" TagName="TextEditor" Src="~/controls/TextEditor.ascx" %>

<table>
    <tr>
        <td class="SubHead">
            <dnn:Label ID="lblPromptText" runat="server" ControlName="txtPromptText" suffix=":" />
        </td>
        <td>
            <dnn:TextEditor ID="txtPromptTextRich" runat="server" Width="400px" Height="350px" HtmlEncode="false" />
            <asp:RequiredFieldValidator ID="PromptTextRequired" runat="server" CssClass="NormalRed"
                Display="dynamic" ControlToValidate="txtPromptTextRich" resourcekey="PromptTextRequired" />
        </td>
    </tr>
    <tr>
        <td class="SubHead">
            <dnn:Label ID="lblAnswer1" runat="server" ControlName="txtAnswer1" Suffix=":" />
        </td>
        <td>
            <asp:TextBox ID="txtAnswer1" runat="server" Width="350px" Height="30px" TextMode="multiLine" MaxLength="500" />
            <asp:RequiredFieldValidator ID="Answer1Required" runat="server" CssClass="NormalRed"
                Display="dynamic" ControlToValidate="txtAnswer1" resourcekey="Answer1Required" />
        </td>
    </tr>
    <tr>
        <td class="SubHead">
            <dnn:Label ID="lblAnswer2" runat="server" ControlName="txtAnswer2" Suffix=":" />
        </td>
        <td>
            <asp:TextBox ID="txtAnswer2" runat="server" Width="350px" Height="30px" TextMode="multiLine" MaxLength="500" />
            <asp:RequiredFieldValidator ID="Answer2Required" runat="server" CssClass="NormalRed"
                Display="dynamic" ControlToValidate="txtAnswer2" resourcekey="Answer2Required" />
        </td>
    </tr>
    <tr>
        <td class="SubHead">
            <dnn:Label ID="lblAnswer3" runat="server" ControlName="txtAnswer3" Suffix=":" />
        </td>
        <td>
            <asp:TextBox ID="txtAnswer3" runat="server" Width="350px" Height="30px" TextMode="multiLine" MaxLength="500" />
            <asp:Label ID="lblAnswer3Required" runat="server" Visible="false" CssClass="NormalRed" resourcekey="lblAnswer3Required" />
        </td>
    </tr>
    <tr>
        <td class="SubHead">
            <dnn:Label ID="lblAnswer4" runat="server" ControlName="txtAnswer4" Suffix=":" />
        </td>
        <td>
            <asp:TextBox ID="txtAnswer4" runat="server" Width="350px" Height="30px" TextMode="multiLine" MaxLength="500" />
            <asp:Label ID="lblAnswer4Required" runat="server" Visible="false" CssClass="NormalRed" resourcekey="lblAnswer4Required" />
        </td>
    </tr>
    <tr>
        <td class="SubHead">
            <dnn:Label ID="lblAnswer5" runat="server" ControlName="txtAnswer5" Suffix=":" />
        </td>
        <td>
            <asp:TextBox ID="txtAnswer5" runat="server" Width="350px" Height="30px" TextMode="multiLine" MaxLength="500" />
        </td>
    </tr>
    <tr>
        <td class="SubHead">
            <dnn:Label ID="lblCorrectAnswer" runat="server" ControlName="ddlCorrectAnswer" Suffix=":" />
        </td>
        <td>
            <asp:DropDownList ID="ddlCorrectAnswer" runat="server">
                <asp:ListItem Text="Answer 1" Value="1" />
                <asp:ListItem Text="Answer 2" Value="2" />
                <asp:ListItem Text="Answer 3" Value="3" />
                <asp:ListItem Text="Answer 4" Value="4" />
                <asp:ListItem Text="Answer 5" Value="5" />
            </asp:DropDownList>
            <asp:Label ID="lblInvalidAnswer" runat="server" Visible="false" CssClass="NormalRed" resourcekey="lblInvalidAnswer" />
        </td>
    </tr>
    <tr>
        <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
        <td colspan="2">
            <asp:linkbutton cssclass="CommandButton" id="btnSave" resourcekey="btnSave" runat="server" borderstyle="none" text="Update" OnClick="btnSave_Click"></asp:linkbutton>&nbsp;
            <asp:linkbutton cssclass="CommandButton" id="btnCancel" resourcekey="btnCancel" runat="server" borderstyle="none" text="Cancel" causesvalidation="False" OnClick="btnCancel_Click"></asp:linkbutton>&nbsp;
        </td>
    </tr>
</table>
