<?php

class Brivium_Credits_ControllerAdmin_Action extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('BRC_action');
	}
	public function actionIndex()
	{
		$actionModel = $this->_getActionModel();
		$actions = $actionModel->getAllActions();
		$actions = $actionModel->prepareActions($actions);
		$viewParams = array(
			'actions' => $actions,
		);
		return $this->responseView('Brivium_Credits_ViewAdmin_Credits_ListActions', 'BRC_action_list', $viewParams);
	}
	
	
	/*========================= Action ================================*/
	

	public function actionAdd()
	{
		return $this->responseReroute('Brivium_Credits_ControllerAdmin_Action', 'edit');
	}
	public function actionEdit()
	{
		$actionModel = $this->_getActionModel();
		if ($actionId = $this->_input->filterSingle('action_id', XenForo_Input::STRING))
		{
			// if a product ID was specified, we should be editing, so make sure a product exists
			$action = $actionModel->getActionById($actionId);
			$action = $actionModel->prepareAction($action);
		}
		else
		{
			// add a new category
			$action = array(
				'action_id' => '',
				'addon_id' => 'Brivium_Credits',
			);
		}
		$addOnModel = $this->_getAddOnModel();
		
		$viewParams = array(
			'templates' => $this->_getEditActionTemplate(),
			'action' => $action,
			'eventOptions' => $this->_getCodeEventModel()->getEventOptions(),
			'masterTitle' => $action['action_id']?$actionModel->getActionTitlePhraseValue($action['action_id']):'',
			'masterRevertedTitle' => $action['action_id']?$actionModel->getActionRevertedTitlePhraseValue($action['action_id']):'',
			'masterExplain' => $action['action_id']?$actionModel->getActionMasterExplainPhraseValue($action['action_id']):'',
			'addOnOptions' => $addOnModel->getAddOnOptionsListIfAvailable(),
			'addOnSelected' => (isset($action['addon_id']) ? $action['addon_id'] : $addOnModel->getDefaultAddOnId()),
		);
		return $this->responseView('XenForo_ViewAdmin_Credits_Action','BRC_action_edit', $viewParams);
	}
	public function actionSave()
	{
		$this->_assertPostOnly();
		if ($this->_input->inRequest('more_options'))
		{
			return $this->responseReroute(__CLASS__, 'add-action');
		}
		$input = $this->_input->filter(array(
			'original_action_id' => XenForo_Input::STRING,
		));

		$dwInput = $this->_input->filter(array(
			'action_id' => XenForo_Input::STRING,
			'display_order' => XenForo_Input::UINT,
			'allow_negative' => XenForo_Input::UINT,
			'addon_id' => XenForo_Input::STRING,
			'negative_handle' => XenForo_Input::STRING,
			'template' => XenForo_Input::STRING,
		));
		$phrase = $this->_input->filter(array(
			'title' => XenForo_Input::STRING,
			'reverted_title' => XenForo_Input::STRING,
			'explain' => XenForo_Input::STRING
		));
		$writer = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Action');
		if ($input['original_action_id'])
		{
			$writer->setExistingData($input['original_action_id']);
		}
		//	prd($dwInput);
		$writer->bulkSet($dwInput);
		$writer->setExtraData(Brivium_Credits_DataWriter_Action::DATA_TITLE, $phrase['title']);
		$writer->setExtraData(Brivium_Credits_DataWriter_Action::DATA_REVERTED_TITLE, $phrase['reverted_title']);
		$writer->setExtraData(Brivium_Credits_DataWriter_Action::DATA_EXPLAIN, $phrase['explain']);
		$writer->setExtraData(Brivium_Credits_DataWriter_Action::DATA_ADDON_ID, $dwInput['addon_id']);
		$writer->updateContent();
		$writer->save();
		
		if ($this->_input->filterSingle('reload', XenForo_Input::STRING))
		{
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::RESOURCE_UPDATED,
				XenForo_Link::buildAdminLink('brc-actions/edit', $writer->getMergedData())
			);
		}
		else
		{
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('brc-actions') . $this->getLastHash($writer->get('action_id'))
			);
		}
	}
	
	public function actionDelete()
	{
		$actionModel = $this->_getActionModel();
		$actionId = $this->_input->filterSingle('action_id', XenForo_Input::STRING);

		if ($this->isConfirmedPost())
		{
			$dw = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Action');
			$dw->setExistingData($actionId);
			$dw->delete();

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('brc-actions')
			);
		}
		else // show confirmation dialog
		{
			$action = $actionModel->getActionById($actionId);
			if($action['global'])
				return $this->responseError(new XenForo_Phrase('BRC_you_cant_delete_global_action'));
			$action['title'] = $actionModel->getActionTitlePhraseValue($action['action_id']);
			$action['explain'] = $actionModel->getActionMasterExplainPhraseValue($action['action_id']);
			$viewParams = array(
				'action' => $action
			);

			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_DeleteAction', 'BRC_action_delete', $viewParams);
		}
	}
	
	public function actionSaveActionConfig()
	{
		$actions = $this->_input->filterSingle('actions', XenForo_Input::ARRAY_SIMPLE);
		foreach($actions AS $actionId=>$action){
			$dw = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Action');
			$dw->setExistingData($actionId);
			$dw->set('amount',$action['amount']);
			if(!isset($action['active']))$action['active']=0;
				$dw->set('active',$action['active']);
			if(!isset($action['alert']))$action['alert']=0;
				$dw->set('alert',$action['alert']);
			$dw->save();
		}
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::RESOURCE_UPDATED,
			XenForo_Link::buildAdminLink('brc-actions')
		);
	}
	
	
	protected function _getEditActionTemplate()
	{
		$allActionTemplates = $this->_getAdminTemplateModel()->getAdminTemplatesForAdminQuickSearch('BRC_action_edit_template_');
		$templates = array();
		foreach($allActionTemplates AS $key=>&$template){
			if($pos = strpos($template['title'], 'BRC_action_edit_template_')!= 1){
				$templateName = substr($template['title'] , ($pos+24));
				$templates[$templateName] = $template['title'];
			}
		}
		return $templates;
	}
	
	/**
	 * Gets the transaction model.
	 *
	 * @return Brivium_Credits_Model_Transaction
	 */
	protected function _getTransactionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Transaction');
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Action
	 */
	protected function _getActionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Action');
	}
	/**
	 * @return XenForo_Model_User
	 */
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}

	/**
	 * @return XenForo_Model_AddOn
	 */
	protected function _getAddOnModel()
	{
		return $this->getModelFromCache('XenForo_Model_AddOn');
	}
	
	/**
	 * Gets the admin template model.
	 *
	 * @return XenForo_Model_AdminTemplate
	 */
	protected function _getAdminTemplateModel()
	{
		return $this->getModelFromCache('XenForo_Model_AdminTemplate');
	}
	/**
	 * Gets the code event model.
	 *
	 * @return XenForo_Model_CodeEvent
	 */
	protected function _getCodeEventModel()
	{
		return $this->getModelFromCache('XenForo_Model_CodeEvent');
	}

	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
	
}