<?php

class Brivium_Credits_ControllerAdmin_Credit extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('BRC_index');
	}
	public function actionIndex()
	{
		$limit = XenForo_Application::get('options')->BRC_memberPerTop;
		$userModel = $this->_getUserModel();
		$transactionModel = $this->_getTransactionModel();
		$stastModel = $this->_getCreditStastModel();
		
		$criteria = array(
			'user_state' => 'valid',
			'is_banned' => 0
		);
		$currencies = XenForo_Application::get('brcCurrencies')->getCurrencies();
		$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
		$actionId 	= $this->_input->filterSingle('action_id', XenForo_Input::STRING);
		
		$actionModel = $this->_getActionModel();
		$actions = $actionModel->getAllActions();
		$action = array();
		$actions = $actionModel->prepareActions($actions);
		if($actionId){
			if(!empty($actions[$actionId])){
				$action = $actions[$actionId];
			}else{
				return $this->responseError(new XenForo_Phrase('BRC_requested_action_not_found'));
			}
		}
		
		$currency 	= array();
		if($currencyId){
			$currency = XenForo_Application::get('brcCurrencies')->$currencyId;
		}else if($currencies){
			$currency = reset($currencies);
		}
		if(!$currency)return $this->responseError(new XenForo_Phrase('BRC_requested_currency_not_found'));
		$currencyId = $currency['currency_id'];
		$fetchOptions = array(
			'limit' => $limit,
			'order' => $currency['column'],
		);
		// richest user
		$fetchOptions['direction'] = 'desc';
		$richest = $userModel->getUsers($criteria, $fetchOptions);
		
		// poorest user
		$fetchOptions['direction'] = 'asc';
		$poorest = $userModel->getUsers($criteria, $fetchOptions);
		
		
		// top transaction in day user
		$dayStartTimestamps = XenForo_Locale::getDayStartTimestamps();
		$conditions = array(
			'start' => $dayStartTimestamps['today'],
			'currency_id' => $currencyId,
		);
		//top in day.
		$topEarnedInDays = $transactionModel->getTopEarnedTransactions($conditions, array('limit' => $limit));
		
		$topSpentInDays = $transactionModel->getTopSpentTransactions($conditions, array('limit' => $limit));
		
		$boardTotals = $this->getModelFromCache('XenForo_Model_DataRegistry')->get('boardTotals');
		if (!$boardTotals)
		{
			$boardTotals = $this->getModelFromCache('XenForo_Model_Counters')->rebuildBoardTotalsCounter();
		}
		
		$creditModel = $this->_getCreditModel();
		$totalCredits 	= $creditModel->totalCredits($currency['column']);
		$totalUsers 	= $boardTotals['users'];
		
		$conditions  = array('currency_id' => $currencyId);
		$statisticRecord = $stastModel->getStatisticRecord($actionId, $currencyId);
		$firstDay = $stastModel->getFirstStatisticDate($actionId, $currencyId);
		$todayStatisticRecord = $stastModel->getStatisticRecord($actionId, $currencyId,'daily');
		
		
		$earnedPerday = 0;
		$spentPerday = 0;
		if($statisticRecord && $firstDay){
			$day = (XenForo_Application::$time - $firstDay);
			if($day <= 86400){
				$day = 1;
			}else{
				$day = ($day - ($day%86400))/86400;
			}
			$earnedPerday = $statisticRecord['total_earn'] / $day;
			$spentPerday = $statisticRecord['total_spend'] / $day;
		}

		
		$viewParams = array(
			'action' 			=> 	$action,
			'actionId' 			=> 	$actionId,
			'actions' 			=> 	$actions,
			'currencies'   		=> $currencies,
			'currency'   		=> $currency,
			
			'totalCredits'  	=> $totalCredits,
			'totalUsers'   		=> $totalUsers,
			
			'earnedPerday'  	=> $earnedPerday,
			'spentPerday'   	=> $spentPerday,
			
			'statisticRecord'   => $statisticRecord,
			'todayStatisticRecord'   => $todayStatisticRecord,
			'firstDay'  		 => $firstDay,
			
			
			'richest'  		 	=> $richest,
			'poorest'   		=> $poorest,
			'topSpentInDays'   	=> $topSpentInDays,
			'topEarnedInDays'   => $topEarnedInDays,
		);
		return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Index', 'BRC_credits', $viewParams);
	}
	
	public function actionUserCredits()
	{
		$criteria = array();

		$filter = $this->_input->filterSingle('_filter', XenForo_Input::ARRAY_SIMPLE);
		if ($filter && isset($filter['value']))
		{
			$criteria['username2'] = array($filter['value'], empty($filter['prefix']) ? 'lr' : 'r');
			$filterView = true;
		}
		else
		{
			$filterView = false;
		}
		$currencies = XenForo_Application::get('brcCurrencies')->getCurrencies();
		$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
		if($currencyId){
			$currency = XenForo_Application::get('brcCurrencies')->$currencyId;
		}else if($currencies){
			$currency = reset($currencies);
		}
		if(!$currency)return $this->responseError(new XenForo_Phrase('BRC_requested_currency_not_found'));
		
		$order = $currency['column'];
		$direction = $this->_input->filterSingle('direction', XenForo_Input::STRING);

		$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
		$usersPerPage = 20;

		$fetchOptions = array(
			'perPage' => $usersPerPage,
			'page' => $page,

			'order' => $order,
			'direction' => $direction
		);

		$userModel = $this->_getUserModel();
		foreach (array('username', 'username2', 'email') AS $field)
		{
			if (isset($criteria[$field]) && is_string($criteria[$field]))
			{
				$criteria[$field] = trim($criteria[$field]);
			}
		}

		$totalUsers = $userModel->countUsers($criteria);
		if (!$totalUsers)
		{
			return $this->responseError(new XenForo_Phrase('no_users_matched_specified_criteria'));
		}

		$users = $userModel->getUsers($criteria, $fetchOptions);
		$orderDirectionEx = ($direction == 'desc' ? 'asc' : 'desc');
		$viewParams = array(
			'currency' => $currency,
			'currencies' => $currencies,
			'users' => $users,
			'totalUsers' => $totalUsers,
			'orderDirectionEx' => $orderDirectionEx,
			'order' => $order,
			'direction' => $direction,
			
			'linkParams' => array('criteria' => $criteria, 'order' => $order, 'direction' => $direction, 'currency_id' => $currency['currency_id']),
			'linkParamsSelect' => array('criteria' => $criteria, 'order' => $order, 'direction' => $direction),
			'page' => $page,
			'usersPerPage' => $usersPerPage,

			'filterView' => $filterView,
			'filterMore' => ($filterView && $totalUsers > $usersPerPage)
		);
		return $this->responseView('Brivium_Credits_ViewAdmin_User_List', 'BRC_user_list', $viewParams);
	}
	
	/*========================= Transfer ================================*/
	public function actionTransfer()
	{
		$creditModel = $this->_getCreditModel();
		$data = $this->_input->filter(array(
			'receiver' => XenForo_Input::STRING,
			'currency_id' => XenForo_Input::UINT,
		));
		$type = 'user';
		$from = 'self';
		$listUserGroups = XenForo_Model::create('XenForo_Model_UserGroup')->getAllUserGroups();
		foreach ($listUserGroups AS $userGroupId => $userGroup)
		{
			if($userGroupId!=0)
			$userGroups[$userGroupId] = array(
				'label' => $userGroup['title'],
				'value' => $userGroup['user_group_id'],
			);
		}
		$currencies = XenForo_Application::get('brcCurrencies')->getCurrencies();
		$eventsObj = XenForo_Application::get('brcEvents');
		foreach($currencies AS $currency){
			$event = $eventsObj->getByCurrency('transfer',$currency['currency_id']);
			if($event && $event['active'] && $currency['active']){
				$currency['event_id'] = $event['event_id'];
				$eventId = $event['event_id'];
			}else{
				unset($currencies[$event['currency_id']]);
			}
		}
		
		
		$viewParams = array(
			'receiver' => $data['receiver'],
			'currencyId' => $data['currency_id'],
			'type' => $type,
			'currencies' => $currencies,
			'from' => $from,
			'userGroups' => $userGroups,
		);

		return $this->responseView(
			'Brivium_Credits_ViewAdmin_Credits_Transfer',
			'BRC_transfer',
			$viewParams
		);
	}
	public function actionDoTransfer()
	{
		$this->_assertPostOnly();
		$data = $this->_input->filter(array(
			'type' => XenForo_Input::STRING,
			'from' => XenForo_Input::STRING,
			'user_group' => XenForo_Input::UINT,
			'anonymous' => XenForo_Input::UINT,
			'receiver' => XenForo_Input::STRING,
			'amount' => XenForo_Input::FLOAT,
			'comment' => XenForo_Input::STRING,
			'redirect' => XenForo_Input::STRING,
			'currency_id' => XenForo_Input::UINT,
		));
		$redirect = ($data['redirect'] ? $data['redirect'] : $this->getDynamicRedirect());
		
		$visitor = XenForo_Visitor::getInstance()->toArray();
		
		
		/* @var $userModel XenForo_Model_user */
		$userModel = $this->getModelFromCache('XenForo_Model_User');
		$userGroupModel = $this->getModelFromCache('XenForo_Model_UserGroup');
		$creditModel = $this->_getCreditModel();
		
		
		list($event, $currency) = $this->_getCreditHelper()->assertEventAndCurrencyValidAndViewable('transfer',$data['currency_id']);
		$currencyObj = XenForo_Application::get('brcCurrencies');
		
		
		$userIds = array();
		if($data['type'] =="usergroup"){
			$users = $userGroupModel->getUserIdsInUserGroup($data['user_group']);
			if(is_array($users) && !$userIds = array_keys($users)){
				$userIds = array();
			}
		}else{
			$receiverUsernames = explode(',',$data['receiver']);
			$receivers = $userModel->getUsersByNames($receiverUsernames);
			if(is_array($receivers) && !$userIds = array_keys($receivers)){
				$userIds = array();
			}
			if (in_array($visitor['user_id'],$userIds) && $data['from'] =="self") {
				return $this->responseError(new XenForo_Phrase('BRC_transfer_self'));
			}
		}
		$neededMoney = 0;
		$creditModel->setIsBulk(true);
		$creditModel->setIsWaitSubmit(true);
		foreach($userIds AS $userId){
			$errorString = '';
			$noError = true;
			if($data['from'] =="self"){
				$selfDataCredit = array(
					'user_action_id' 	=>	$userId,
					'user' 	=>	$visitor,
					'amount' 			=>	-$data['amount'],
					'message' 			=>	$data['anonymous']?(new XenForo_Phrase('BRC_anonymous_transfer') .': '. $data['comment']):$data['comment'],
					'currency_id'		=>	$currency['currency_id'],
					'ignoreInclude' 	=>	true,
					'extraData' 		=>	array('type'	=>	'sender',)
				);
				$noError = $creditModel->updateUserCredit('transfer',$visitor['user_id'],$selfDataCredit,$errorString);
				//if($errorString)return $this->responseError($errorString);
				$visitorId = XenForo_Visitor::getUserId();
			}else{
				$visitorId = 0;
			}
			if($noError)
			{
				$neededMoney += $data['amount'];
				$errorString = '';
				$dataCredit = array(
					'user_action_id' 	=>	$data['anonymous']?$userId:$visitorId,
					'amount' 			=>	$data['amount'],
					'message' 			=>	$data['anonymous']?(new XenForo_Phrase('BRC_anonymous_transfer') .': '. $data['comment']):$data['comment'],
					'currency_id'		=>	$currency['currency_id'],
					'ignoreInclude' 	=>	true,
					'extraData' 		=>	array('type'=>'receiver', 'anonymous'	=>	$data['anonymous'])
				);
				$creditModel->updateUserCredit('transfer',$userId,$dataCredit,$errorString);
			}
			//if($errorString)return $this->responseError($errorString);
		}
		
		if($data['from'] =="self" && ($visitor[$currency['column']] - $neededMoney) < 0){
			return $this->responseError(new XenForo_Phrase('BRC_not_enough_transfer',array('amount' => $currencyObj->currencyFormat($neededMoney,false,$currency['currency_id']))));
		}
		
		$creditModel->commitUpdate();
		$viewParams = array();
		
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			$redirect,
			new XenForo_Phrase('BRC_transaction_processed_successfully')
		);
	}
	
	/**
	 * Remove credits of all users.
	 *
	 */
	public function actionResetCredit()
	{
		if ($this->isConfirmedPost())
		{
			$deleteTransaction = $this->_input->filterSingle('delete_transaction', XenForo_Input::UINT);
			$type = $this->_input->filterSingle('type', XenForo_Input::STRING);
			$amount = $this->_input->filterSingle('amount', XenForo_Input::UINT);
			$creditModel = $this->_getCreditModel();
			$data = $this->_input->filter(array(
				'user_group' => XenForo_Input::UINT,
				'username' => XenForo_Input::STRING,
				'amount' => XenForo_Input::FLOAT,
			));
			
			$userModel = $this->getModelFromCache('XenForo_Model_User');
			$userGroupModel = $this->getModelFromCache('XenForo_Model_UserGroup');
			$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
			$userIds = array();
			if($type =="usergroup"){
				$users = $userGroupModel->getUserIdsInUserGroup($data['user_group']);
				if(is_array($users) && !$userIds = array_keys($users)){
					$userIds = array();
				}
			}else if($type =="user"){
				$receiver = $userModel->getUserByName($data['username']);
				if (empty($receiver)) {
					return $this->responseError(new XenForo_Phrase('requested_user_not_found'));
				}
				$userIds[] = $receiver['user_id'];
			}
			$columns = array();
			if($currencyId){
				$currency = XenForo_Application::get('brcCurrencies')->$currencyId;
				$columns[$currency['column']] = $amount;
			}else{
				$currencies = XenForo_Application::get('brcCurrencies')->getCurrencies();
				foreach($currencies AS $currency){
					$columns[$currency['column']] = $amount;
				}
			}
			if($userIds ||  $type =="all"){
				$creditModel->resetCredit($columns,$userIds);
				if($deleteTransaction){
					$this->_getTransactionModel()->deleteAllTransaction($currencyId,$userIds);
				}
			}
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('credits/user-credits'),
				new XenForo_Phrase('BRC_transaction_processed_successfully')
			);
		}
		else
		{
			$userGroups = array();
			$listUserGroups = XenForo_Model::create('XenForo_Model_UserGroup')->getAllUserGroups();
			foreach ($listUserGroups AS $userGroupId => $userGroup)
			{
				if($userGroupId!=0)
				$userGroups[$userGroupId] = array(
					'label' => $userGroup['title'],
					'value' => $userGroup['user_group_id'],
				);
			}
			$viewParams = array(
				'userGroups' => $userGroups,
				'currencies' => XenForo_Application::get('brcCurrencies')->getCurrencies(),
			);
			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_ResetCredit', 'BRC_reset_credit', $viewParams);
		}
		
	}
	/*========================= Import Export ================================*/
	public function actionImportCredits()
	{
		$importBdBank = false;
		$bdBankAddon = XenForo_Model::create('XenForo_Model_AddOn')->getAddOnVersion('bdbank');
		if ($bdBankAddon) {
			$importBdBank = true;
        }
		$importMyPoints = false;
		$myPointsAddon = XenForo_Model::create('XenForo_Model_AddOn')->getAddOnVersion('bdbank');
		if ($myPointsAddon) {
			$importMyPoints = true;
        }
		$viewParams = array(
			'importBdBank' => $importBdBank,
			'importMyPoints' => $importMyPoints,
		);
		return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Import', 'BRC_import_credits', $viewParams);
	}
	/**
	 * Import money from BdBanking to credits
	 *
	 */
	public function actionImportTrophyPoints()
	{
		if ($this->isConfirmedPost())
		{
			$userModel = $this->_getUserModel();
			$users = $userModel->getUsers(array());
			$creditModel = $this->_getCreditModel();
			$type = $this->_input->filterSingle('type', XenForo_Input::UINT);
			$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
			if($currencyId){
				$currency = XenForo_Application::get('brcCurrencies')->$currencyId;
			}else{
				return $this->responseError(new XenForo_Phrase('BRC_requested_currency_not_found'));
			}
			$removeTrophyPoints = $this->_input->filterSingle('remove_trophy_points', XenForo_Input::UINT);
			$merge = true;
			if($type !='merge'){
				$merge = false;
			}
			$creditModel->importCredits('trophy_points',$currency['column'],$merge);
			if($removeTrophyPoints)$creditModel->resetTrophyPoints();
			return $this->responseMessage(new XenForo_Phrase('BRC_import_successfully'));
		}
		else
		{
			$viewParams = array(
				'type' => 'merge',
				'trophyPoints' => true,
				'currencies' => XenForo_Application::get('brcCurrencies')->getCurrencies(),
			);
			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Import_TrophyPoints', 'BRC_confirm_import_credits', $viewParams);
		}
		
	}/**
	 * Import money from BdBanking to credits
	 *
	 */
	public function actionImportMyPoints()
	{
		if ($this->isConfirmedPost())
		{
			$creditModel = $this->_getCreditModel();
			$type = $this->_input->filterSingle('type', XenForo_Input::UINT);
			$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
			if($currencyId){
				$currency = XenForo_Application::get('brcCurrencies')->$currencyId;
			}else{
				return $this->responseError(new XenForo_Phrase('BRC_requested_currency_not_found'));
			}
			$myPoints = XenForo_Model::create('XenForo_Model_AddOn')->getAddOnVersion('myPoints');
			if (!$myPoints) {
				return $this->responseError('MyPoints Addon required');
			}
			$merge = true;
			if($type !='merge'){
				$merge = false;
			}
			$creditModel->importCredits('mypoints_currency',$currency['column'],$merge);
			$creditModel->importCredits('mypoints_currency',$merge);
			return $this->responseMessage(new XenForo_Phrase('BRC_import_successfully'));
		}
		else
		{
			$viewParams = array(
				'type' => 'merge',
				'currencies' => XenForo_Application::get('brcCurrencies')->getCurrencies(),
			);
			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Import_MyPoints', 'BRC_confirm_import_credits', $viewParams);
		}
		
	}
	/**
	 * Import money from BdBanking to credits
	 *
	 */
	public function actionImportBdBanking()
	{
		if ($this->isConfirmedPost())
		{
			$userModel = $this->_getUserModel();
			$users = $userModel->getUsers(array());
			$bdBankAddon = XenForo_Model::create('XenForo_Model_AddOn')->getAddOnVersion('bdbank');
			if (!$bdBankAddon) {
				return $this->responseError('[bd] Banking Addon required');
			}
			$type = $this->_input->filterSingle('type', XenForo_Input::UINT);
			$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
			if($currencyId){
				$currency = XenForo_Application::get('brcCurrencies')->$currencyId;
			}else{
				return $this->responseError(new XenForo_Phrase('BRC_requested_currency_not_found'));
			}
			$bdbankField = XenForo_Application::get("options")->bdbank_field;
			$creditModel = $this->_getCreditModel();
			$merge = true;
			if($type !='merge'){
				$merge = false;
			}
			$creditModel->importCredits($bdbankField,$currency['column'],$merge);
			return $this->responseMessage(new XenForo_Phrase('BRC_import_successfully'));
		}
		else
		{
			$viewParams = array(
				'type' => 'merge',
				'currencies' => XenForo_Application::get('brcCurrencies')->getCurrencies(),
			);
			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Import_MyPoints', 'BRC_confirm_import_credits', $viewParams);
		}
	}
	
	protected function _getFilterParams()
	{
		return $this->_input->filter(array(
			'order' => XenForo_Input::STRING,
			'action_id' => XenForo_Input::STRING,
			'currency_id' => XenForo_Input::UINT,
			'username' => XenForo_Input::STRING,
			'start' => XenForo_Input::STRING,
			'end' => XenForo_Input::STRING
		));
	}
	
	/**
	 * Gets the transaction model.
	 *
	 * @return Brivium_Credits_Model_Transaction
	 */
	protected function _getTransactionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Transaction');
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Action
	 */
	protected function _getActionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Action');
	}
	/**
	 * @return XenForo_Model_User
	 */
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}

	/**
	 * @return XenForo_Model_AddOn
	 */
	protected function _getAddOnModel()
	{
		return $this->getModelFromCache('XenForo_Model_AddOn');
	}
	
	/**
	 * Gets the admin template model.
	 *
	 * @return XenForo_Model_AdminTemplate
	 */
	protected function _getAdminTemplateModel()
	{
		return $this->getModelFromCache('XenForo_Model_AdminTemplate');
	}
	
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
	protected function _getCreditHelper()
	{
		return $this->getHelper('Brivium_Credits_ControllerHelper_Credit');
	}
	
	protected function _getCreditStastModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_CreditStast');
	}
	
}