<?php

class Brivium_Credits_ControllerAdmin_Transaction extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('BRC_transaction');
	}
	public function actionIndex()
	{
		if ($this->_input->inRequest('delete_selected'))
		{
			return $this->responseReroute(__CLASS__, 'delete');
		}
		if ($this->_input->inRequest('update'))
		{
			return $this->responseReroute(__CLASS__, 'update');
		}
		$export = false;
		if ($this->_input->inRequest('export'))
		{
			$export = true;
		}
		
		
		$input = $this->_getFilterParams();

		$dateInput = $this->_input->filter(array(
			'start' => XenForo_Input::DATE_TIME,
			'end' => XenForo_Input::DATE_TIME,
		));

		$transactionModel = $this->_getTransactionModel();

		$moderate = $this->_input->filterSingle('moderate', XenForo_Input::UINT);
		
		$pageParams = array();
		if ($input['order'])
		{
			$pageParams['order'] = $input['order'];
		}
		if ($input['start'])
		{
			$pageParams['start'] = $input['start'];
		}
		if ($input['end'])
		{
			$pageParams['end'] = $input['end'];
		}
		if ($input['action_id'])
		{
			$pageParams['action_id'] = $input['action_id'];
		}
		if ($input['currency_id'])
		{
			$pageParams['currency_id'] = $input['currency_id'];
		}

		$userId = 0;
		if ($input['username'])
		{
			if ($user = $this->getModelFromCache('XenForo_Model_User')->getUserByName($input['username']))
			{
				$userId = $user['user_id'];
				$pageParams['username'] = $input['username'];
			}
			else
			{
				$input['username'] = '';
			}
		}

		$conditions = array(
			'action_id' => $input['action_id'],
			'currency_id' => $input['currency_id'],
			'moderate' => $moderate,
			'user_id' => $userId,
			'start' => $dateInput['start'],
			'end' => $dateInput['end'],
		);
		if(!$export){
			$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
			$perPage = 50;

			$fetchOptions = array(
				'page' => $page,
				'perPage' => $perPage,
				'join' =>  Brivium_Credits_Model_Transaction::FETCH_TRANSACTION_FULL
			);
		}else{
			$fetchOptions = array(
				'join' =>  Brivium_Credits_Model_Transaction::FETCH_TRANSACTION_FULL
			);
		}
		switch ($input['order'])
		{
			case 'amount':
				$fetchOptions['order'] = 'amount';
				break;

			case 'transaction_date';
			default:
				$input['order'] = 'transaction_date';
				$fetchOptions['order'] = 'transaction_date';
				break;
		}

		$transactions = $transactionModel->getTransactions($conditions, $fetchOptions);
		$transactions = $transactionModel->prepareTransactions($transactions);
		if($export){
			$name = "Brivium_Transaction_Export_" . date("Y-m-d_h-i-s-A") . ".csv";
			$fileName = "data/transactions/". $name;
			$directory = dirname($fileName);

			if (XenForo_Helper_File::createDirectory($directory, true))
			{
				$fp = fopen($fileName, 'w');
				$header = array(
					'Transaction Id',
					'Action',
					'Currency Id',
					'User Id',
					'User Name',
					'User Action Id',
					'User Action Name',
					'Amount',
					'Reverted',
					'Status',
					'Transaction Date',
					'Message',
				);
				fputcsv($fp, $header);
					foreach ($transactions as $transaction) {
						$transaction['reverted'] = !empty($transaction['extraData']['reverted'])?'Reverted':'';
						$newTransaction = array(
							$transaction['transaction_id'],
							$transaction['action'],
							$transaction['currency_id'],
							$transaction['user_id'],
							$transaction['username'],
							$transaction['user_action_id'],
							$transaction['user_action_name'],
							$transaction['amount_phrase'],
							$transaction['reverted'],
							$transaction['moderate']?new XenForo_Phrase('BRC_pending'):new XenForo_Phrase('BRC_complete'),
							XenForo_Template_Helper_Core::dateTime($transaction['transaction_date'],'absolute'),
							$transaction['message'],
						);
						fputcsv($fp, $newTransaction);
					}
				fclose($fp);
				XenForo_Helper_File::makeWritableByFtpUser($fileName);
			}
			
			$this->_routeMatch->setResponseType('raw');
			
			$viewParams = array(
				'transactions' => array(
					'filename' =>  $name,
					'export_date' => XenForo_Application::$time,
					'file_size' => filesize($fileName),
				),
				'transactionsFile' => $fileName,
			);
			
			return $this->responseView(
				'Brivium_Credits_ViewAdmin_Credits_Transactions',
				'',
				$viewParams
			);
		}
		
		$actionModel = $this->_getActionModel();
		$actions = $actionModel->getAllActions();
		$actions = $actionModel->prepareActions($actions);
		
		$viewParams = array(
			'actions' => $actions,
			'currencies' => XenForo_Application::get('brcCurrencies')->getCurrencies(),
			'transactions' => $transactions,
			'moderate' => $moderate,

			'order' => $input['order'],
			'actionId' => $input['action_id'],
			'currencyId' => $input['currency_id'],
			'username' => $input['username'],
			'start' => $input['start'],
			'end' => $input['end'],

			'datePresets' => XenForo_Helper_Date::getDatePresets(),

			'page' => $page,
			'perPage' => $perPage,
			'pageParams' => $pageParams,
			'total' =>	$transactionModel->countTransactions($conditions)
		);

		return $this->responseView('Brivium_Credits_ViewAdmin_Credits_Transactions', 'BRC_transaction_list', $viewParams);
	}
	
	public function actionView()
	{
		$transactionId = $this->_input->filterSingle('transaction_id', XenForo_Input::UINT);
		$transactionModel = $this->_getTransactionModel();
		$fetchOptions = array(
			'join' =>  Brivium_Credits_Model_Transaction::FETCH_TRANSACTION_FULL
		);
		$transaction = $transactionModel->getTransactionById($transactionId,$fetchOptions);
		$viewParams = array(
			'transaction' => $transactionModel->prepareTransaction($transaction),
		);
		return $this->responseView('Brivium_Credits_ViewAdmin_Credits_ViewTransaction', 'BRC_view_transaction', $viewParams);
	}
	
	
	public function actionSave()
	{
		$transactionId = $this->_input->filterSingle('transaction_id', XenForo_Input::UINT);
		$complete = $this->_input->filterSingle('complete', XenForo_Input::UINT);
		$moderate = $complete?false:true;
		$transactionModel = $this->_getTransactionModel();
		$fetchOptions = array(
			'join' =>  Brivium_Credits_Model_Transaction::FETCH_TRANSACTION_FULL
		);
		$transaction = $transactionModel->getTransactionById($transactionId,$fetchOptions);
		
		$dw = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Transaction');
		$dw->setExistingData($transactionId);
		$dw->setOption(Brivium_Credits_DataWriter_Transaction::OPTION_ALLOW_CREDIT_CHANGE, false);
		$dw->set('moderate',$moderate);
		$dw->save();
	
		$filterParams = $this->_getFilterParams();
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('brc-transactions', null, $filterParams)
		);
	}
	
	public function actionUpdate()
	{
		$transactionModel = $this->_getTransactionModel();
		
		$filterParams = $this->_getFilterParams();

		$transactionIds = $this->_input->filterSingle('transaction_ids', array(XenForo_Input::UINT, 'array' => true));

		if ($transactionId = $this->_input->filterSingle('transaction_id', XenForo_Input::UINT))
		{
			$transactionIds[] = $transactionId;
		}
		$transactionId = $this->_input->filterSingle('transaction_id', XenForo_Input::UINT);
		foreach ($transactionIds AS $transactionId)
		{
			$dw = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Transaction');
			$dw->setExistingData($transactionId);
			$dw->set('moderate',0);
			$dw->save();
		}
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('brc-transactions', null, $filterParams)
		);
	}
	
	public function actionDelete()
	{
		$transactionModel = $this->_getTransactionModel();
		
		$filterParams = $this->_getFilterParams();

		$transactionIds = $this->_input->filterSingle('transaction_ids', array(XenForo_Input::UINT, 'array' => true));

		if ($transactionId = $this->_input->filterSingle('transaction_id', XenForo_Input::UINT))
		{
			$transactionIds[] = $transactionId;
		}
		$transactionId = $this->_input->filterSingle('transaction_id', XenForo_Input::UINT);

		if ($this->isConfirmedPost())
		{
			foreach ($transactionIds AS $transactionId)
			{
				$dw = XenForo_DataWriter::create('Brivium_Credits_DataWriter_Transaction');
				$dw->setExistingData($transactionId);
				$dw->delete();
			}
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('brc-transactions', null, $filterParams)
			);
		}
		else // show confirmation dialog
		{
			$fetchOptions = array(
				'join' =>  Brivium_Credits_Model_Transaction::FETCH_TRANSACTION_FULL
			);
			$viewParams = array(
				'transactionIds' => $transactionIds,
				'filterParams' => $filterParams
			);

			if (count($transactionIds) == 1)
			{
				list($transactionId) = $transactionIds;
				$transactions = $transactionModel->getTransactionById($transactionId,$fetchOptions);
				if($transactions)
				$viewParams['transaction'] = $transactionModel->prepareTransaction($transactions);
			}
			return $this->responseView('Brivium_Credits_ViewAdmin_Credits_DeleteTransaction', 'BRC_transaction_delete', $viewParams);
		}
	}
	
	protected function _getFilterParams()
	{
		return $this->_input->filter(array(
			'order' => XenForo_Input::STRING,
			'action_id' => XenForo_Input::STRING,
			'currency_id' => XenForo_Input::UINT,
			'username' => XenForo_Input::STRING,
			'start' => XenForo_Input::STRING,
			'end' => XenForo_Input::STRING
		));
	}
	
	/**
	 * Gets the transaction model.
	 *
	 * @return Brivium_Credits_Model_Transaction
	 */
	protected function _getTransactionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Transaction');
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Action
	 */
	protected function _getActionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Action');
	}
	/**
	 * @return XenForo_Model_User
	 */
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}

	/**
	 * @return XenForo_Model_AddOn
	 */
	protected function _getAddOnModel()
	{
		return $this->getModelFromCache('XenForo_Model_AddOn');
	}
	
	/**
	 * Gets the admin template model.
	 *
	 * @return XenForo_Model_AdminTemplate
	 */
	protected function _getAdminTemplateModel()
	{
		return $this->getModelFromCache('XenForo_Model_AdminTemplate');
	}
	
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
	
}