<?php

class Brivium_Credits_ControllerHelper_Credit extends XenForo_ControllerHelper_Abstract
{
	/**
	 * The current browsing user.
	 *
	 * @var XenForo_Visitor
	 */
	protected $_visitor;
	protected $_eventsObj;
	protected $_currencyObj;

	/**
	 * Additional constructor setup behavior.
	 */
	protected function _constructSetup()
	{
		$this->_visitor = XenForo_Visitor::getInstance()->toArray();
		$this->_eventsObj = XenForo_Application::get('brcEvents');
		$this->_currencyObj = XenForo_Application::get('brcCurrencies');
	}
	public function assertCurrenciesValidAndViewable($actionId = '')
	{
		if(!$actionId) return array();
		$creditModel = $this->_controller->getModelFromCache('Brivium_Credits_Model_Credit');
		$currencies = $this->_currencyObj->getCurrencies();
		foreach($currencies AS $currencyId=>$currency){
			$event = $this->_eventsObj->getByCurrency($actionId,$currency['currency_id']);
			if(is_array($event) && empty($event['event_id'])){
				$remove = true;
				foreach($event AS $subEvent){
					if($event && $creditModel->requireInclude($subEvent,$this->_visitor)){
						$remove = false;
					}
				}
				if($remove)unset($currencies[$currencyId]);
			}else{
				if(!$event || !$creditModel->requireInclude($event,$this->_visitor)){
					unset($currencies[$currencyId]);
				}
			}
		}
		return $currencies;
	}
	
	
	public function assertEventAndCurrencyValidAndViewable($actionId = '',$currencyId = 0)
	{
		if(!$actionId || !$currencyId) throw $this->_controller->getNoPermissionResponseException();
		$event = $this->_eventsObj->getByCurrency($actionId,$currencyId);
		$currency = $this->_currencyObj->$currencyId;
		$creditModel = $this->_controller->getModelFromCache('Brivium_Credits_Model_Credit');
		
		if(is_array($event) && empty($event['event_id'])){
			$event = reset($event);
		}
		if(!$event || !$creditModel->requireInclude($event,$this->_visitor)){
			throw $this->_controller->getNoPermissionResponseException();
		}
		if(!isset($this->_visitor[$currency['column']])){
			throw $this->_controller->getErrorOrNoPermissionResponseException(new XenForo_Phrase('BRC_field_x_was_not_recognised',array('field'=>$currency['column'])));
		}
		return array($event,$currency);
	}

	
	public function getWrapper($selectedGroup, $selectedLink, XenForo_ControllerResponse_View $subView)
	{
		$currencyDisplay = XenForo_Application::get('options')->get('BRC_currencyDisplay');
		if(isset($currencyDisplay[0]) && ($currencyDisplay[0]==''||$currencyDisplay[0]==0)){
			$currencyDisplay = array();
		}
		$viewParams = array(
			'currencyDisplay' => $currencyDisplay,
			'selectedGroup' => $selectedGroup,
			'selectedLink' => $selectedLink,
			'selectedKey' => "$selectedGroup/$selectedLink",
			'currencies' => XenForo_Application::get('brcCurrencies')->getCurrencies(),
			'canWithdraw' => $this->_controller->getModelFromCache('Brivium_Credits_Model_Credit')->checkRequireInclude('withdraw'),
			'canTransfer' => $this->_controller->getModelFromCache('Brivium_Credits_Model_Credit')->checkRequireInclude('transfer'),
		);

		$wrapper = $this->_controller->responseView('Brivium_Credits_ViewPublic_Credit_Wrapper', 'BRC_credit_wrapper', $viewParams);
		$wrapper->subView = $subView;

		return $wrapper;
	}

	public static function wrap(XenForo_Controller $controller, $selectedGroup, $selectedLink, XenForo_ControllerResponse_View $subView)
	{
		$helper = new self($controller);
		return $helper->getWrapper($selectedGroup, $selectedLink, $subView);
	}
}