<?php

class Brivium_Credits_ControllerPublic_Member extends XFCP_Brivium_Credits_ControllerPublic_Member
{
	public function actionIndex()
    {
		$response = parent::actionIndex();
		if (!$this->_getCreditModel()->canUseCredits($error))
		{
			$currencyDisplay = XenForo_Application::get('options')->get('BRC_currencyDisplay');
			if(isset($currencyDisplay[0]) && ($currencyDisplay[0]==''||$currencyDisplay[0]==0)){
				$currencyDisplay = array();
			}
			$currencies = XenForo_Application::get('brcCurrencies')->getCurrencies();
			$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
			$response->params['currencyDisplay'] = $currencyDisplay;
			$response->params['currencyId'] = $currencyId;
			if($currencies){
				$response->params['brcCurrencies'] = $currencies;
			}
		}
		return $response;
    }
	protected function _getNotableMembers($type, $limit)
	{
		$result = parent::_getNotableMembers($type, $limit);
		if (!$this->_getCreditModel()->canUseCredits($error))
		{
			if(!$result && $type=='richest_credits'){
				$userModel = $this->_getUserModel();
				$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
				$currency = XenForo_Application::get('brcCurrencies')->$currencyId;
				if(!$currency)return $this->responseError(new XenForo_Phrase('BRC_requested_currency_not_found'));
				
				$notableCriteria = array(
					'is_banned' => 0
				);
				$typeMap = array(
					'richest_credits' => $currency['column'],
				);

				if (!isset($typeMap[$type]))
				{
					return false;
				}

				return array($userModel->getUsers($notableCriteria, array(
					'join' => XenForo_Model_User::FETCH_USER_FULL,
					'limit' => $limit,
					'order' => $currency['column'],
					'direction' => 'desc'
				)), $typeMap[$type]);
			}
		}
		return $result;
	}
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
}
