<?php
class Brivium_Credits_DataWriter_DiscussionMessage_Post extends XFCP_Brivium_Credits_DataWriter_DiscussionMessage_Post
{

	protected function _messagePreSave(){
		$creditModel = $this->_getCreditModel();
		
		if ($this->isInsert() && !$this->isDiscussionFirstMessage())
		{
			$creditModel->setIsWaitSubmit(true);
			$thread = $this->_getThreadModel()->getThreadById($this->get('thread_id'));
			$post = $this->getMergedData();
			$wordCount = $creditModel->calculateWordAmount(strtolower($post['message']));
			$dataCredit = array(
				'node_id'			=>	$thread['node_id'],
				'multiplier'		=>	$wordCount,
				'content_id' 		=>	$this->get('thread_id'),
				'content_type'		=>	'thread',
				'errorMinimumHandle'	=>	new XenForo_Phrase('BRC_post_needs_to_have_at_least_x_words'),
				'extraData' 	=>	array('post_id'=>$this->get('post_id'))
			);
			$creditModel->updateUserCredit('newPost',$post['user_id'],$dataCredit);
			if($thread['user_id']!=$this->get('user_id')){
				$dataCredit = array(
					'user_action_id' 	=>	$post['user_id'],
					'node_id'			=>	$thread['node_id'],
					'content_id' 		=>	$this->get('thread_id'),
					'content_type'		=>	'thread',
					'extraData' 		=>	array('post_id'=>$this->get('post_id'))
				);
				$creditModel->updateUserCredit('threadGetReply',$thread['user_id'],$dataCredit);
			}
			$creditModel->commitUpdate();
		}
		return parent::_messagePreSave();
	}
	protected function _messagePostSave()
	{
		$creditModel = $this->_getCreditModel();
		$uploadedNew = false;
		$newAttachCount = 0;
		if ($this->isInsert() && $this->get('attach_count')){
			$uploadedNew = true;
			$newAttachCount = $this->get('attach_count');
		}else if($this->isUpdate() && ($this->get('attach_count') > $this->getExisting('attach_count'))){
			$uploadedNew = true;
			$newAttachCount = $this->get('attach_count') - $this->getExisting('attach_count') ;
		}
		if($uploadedNew && $newAttachCount){
			$thread = $this->_getThreadModel()->getThreadById($this->get('thread_id'));
			
			$dataCredit = array(
				'node_id'		=>	$thread['node_id'],
				'multi_amount' 	=> 	$newAttachCount,
				'content_id' 	=>	$this->get('post_id'),
				'content_type'	=>	'post',
				'extraData' 	=>	array('post_id'=>$this->get('post_id'))
			);
			$creditModel->updateUserCredit('uploadAttachment',$this->get('user_id'),$dataCredit);
		}
		$creditModel->commitUpdate();
		return parent::_messagePostSave();
	}


	protected function _messagePostDelete()
	{
		if (!$this->isDiscussionFirstMessage())
		{
			$post = $this->getMergedExistingData();
			$creditModel = $this->_getCreditModel();
			$thread = $this->_getThreadModel()->getThreadById($this->get('thread_id'));
			$wordCount = $creditModel->calculateWordAmount(strtolower($post['message']));
			$dataCredit = array(
				'node_id'		=>	$thread['node_id'],
				'multiplier'	=>	$wordCount,
				'content_id' 	=>	$this->get('post_id'),
				'content_type'	=>	'post',
				'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
			);
			$creditModel->updateUserCredit('postDeleted',$this->get('user_id'),$dataCredit);
		}
		return parent::_messagePostDelete();
	}
	
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
	
}