<?php

class Brivium_Credits_Model_AddOn extends XFCP_Brivium_Credits_Model_AddOn
{
	/**
	 * Imports all the add-on associated XML into the DB and rebuilds the
	 * caches.
	 *
	 * @param SimpleXMLElement $xml Root node that contains all of the "data" nodes below
	 * @param string $addOnId Add-on to import for
	 */
	public function importAddOnExtraDataFromXml(SimpleXMLElement $xml, $addOnId)
	{
		parent::importAddOnExtraDataFromXml($xml, $addOnId);
		if ($addOnId != 'Brivium_Credits') {
			$this->getModelFromCache('Brivium_Credits_Model_Action')->importActionsAddOnXml($xml->brc_actions, $addOnId);
		}
		
	}

	/**
	 * Gets the XML data for the specified add-on.
	 *
	 * @param array $addOn Add-on info
	 *
	 * @return DOMDocument
	 */
	public function getAddOnXml(array $addOn)
	{
		$document = parent::getAddOnXml($addOn);
		if ($addOn['addon_id'] != 'Brivium_Credits') {
			$rootNode = $document->documentElement;
			$addOnId = $addOn['addon_id'];
			$dataNode = $rootNode->appendChild($document->createElement('brc_actions'));
			$this->getModelFromCache('Brivium_Credits_Model_Action')->appendActionsAddOnXml($dataNode, $addOnId);
		}
		return $document;
	}
	
	public function deleteAddOnMasterData($addOnId)
	{
		parent::deleteAddOnMasterData($addOnId);
		if ($addOnId != 'Brivium_Credits') {
			$this->getModelFromCache('Brivium_Credits_Model_Action')->deleteActionsForAddOn($addOnId);
		}
	}
}