<?php
class Brivium_Credits_Model_Thread extends XFCP_Brivium_Credits_Model_Thread
{
	/**
	 * Marks the given thread as read up to a certain point (usually the most recent post read).
	 * Thread must have thread_read_date key. (Forum should have forum_read_date key.)
	 *
	 * @param array $thread Thread info
	 * @param array $forum Forum info
	 * @param integer $readDate Timestamp to mark
	 * @param array|null $viewingUser
	 *
	 * @return boolean True if marked as read
	 */
	public function markThreadRead(array $thread, array $forum, $readDate, array $viewingUser = null)
	{
		
		$result = parent::markThreadRead($thread,$forum,$readDate,$viewingUser);
		if(!isset($viewingUser['user_id'])){
			$this->standardizeViewingUserReference($viewingUser);
		}
		$userId = $viewingUser['user_id'];
		if($thread['user_id'] != $userId && (($userId && $result) ||(!$userId && XenForo_Application::get('options')->BRC_guestTriggerViewActions))){
			$creditModel = $this->getModelFromCache('Brivium_Credits_Model_Credit');
			if($userId){
				if($creditModel->countActionOfUser('readThread',$userId,0,0,$thread['thread_id'],'thread')){
					return $result;
				}
				$dataCredit = array(
					'user' 			=>	$viewingUser,
					'content_id' 	=>	$thread['thread_id'],
					'content_type'	=>	'thread',
					'node_id' 		=>	$thread['node_id'],
					'extraData' 	=>	array('thread_id'=>$thread['thread_id'])
				);
				$creditModel->updateUserCredit('readThread',$userId,$dataCredit);
			}
			if($thread['user_id'])
			{
				$dataCredit = array(
					'content_id' 	=>	$thread['thread_id'],
					'content_type'	=>	'thread',
					'node_id' 			=>	$thread['node_id'],
					'extraData' 	=>	array('thread_id'=>$thread['thread_id'])
				);
				$creditModel->updateUserCredit('threadViewed',$thread['user_id'],$dataCredit);
			}
		}
		return $result;
	}
	
}