# Coded By BitFire Team - All Rights Reserved

# تابع پردازش اصلی - این تابع روی هر خط ورودی اجرا می شود
def solve(data: str):
    # ذخیره ورودی برای پردازش نهایی
    tmp_data = data
    
    # حذف علامت (؟) برای محاسبه ی میانگین اعداد 
    data = data.replace("?","")
    data = data.strip()

    # حذف فاصله های اضافه در رشته (برای مثال اگر دو فاصله کنار هم قرار داشته باشند آنها را به یک فاصله تبدیل می کند)
    cleaner = ""
    prev_char = ""
    for char in data:
        if prev_char == " " and char == " ":
            pass
        else:
            cleaner += char
            prev_char = char
    data = cleaner

    # جدا کردن اعداد (به صورت رشته) از یکدیگر
    values = data.split(" ")

    # تبدیل نوع اعداد داخل لیست از رشته به عدد صحیح
    values = list(map(lambda x: int(x),values))

    # محاسبه میانگین
    avg = sum(values)/len(values)

    # تبدیل میانگین به رشته و محدود کردن به دو رقم اعشار
    avg = "{:.2f}".format(avg)

    # جایگذاری میانگین محاسبه شده به جای علامت های (؟) در رشته ورودی اولیه
    tmp_data = tmp_data.replace("?",str(avg))

    return tmp_data

# تابع ایجاد خروجی - بر روی هر سطر ورودی، تابع اصلی را اجرا می کند و خروجی اش را در فایل دیگری می نویسد
def export(entries_file_name,export_file_name,function):
    with open(entries_file_name,'r') as file:
        tmp_entries = file.readlines()
        entries = list()
        for entry in tmp_entries:
            entries.append(entry.replace('\n',''))
        file.close()

    with open(export_file_name,'w') as file:
        exports = list()
        counter = 0
        for entry in entries:
            entry = str(entry)

            if len(entries)-1 == counter:
                exports.append(str(function(entry)))
            else:
                exports.append(str(function(entry))+'\n')
            counter += 1
        file.writelines(exports)
        file.close()

export('input.txt','soal1.txt',solve)