# Coded By BitFire Team - All Rights Reserved

# تابع پردازش اصلی - این تابع روی هر خط ورودی اجرا می شود
def solve(data: str):
    word = data.strip()

    # مجموعه ی اعداد صدادار
    vowels = "aeiouAEIOU"

    if len(word) <= 3:
        # برگرداندن کلمه به عنوان خروجی در صورتی که طول رشته از 3 کمتر باشد
        return word
    else:
        # حذف حروف صدادار از کلمه
        result = ""
        for ch in word:
            if ch not in vowels:
                result += ch
    
        # خلاصه سازی به حداکثر سه حرف و تبدیل به حروف کوچک
        return result[:3].lower()

# تابع ایجاد خروجی - بر روی هر سطر ورودی، تابع اصلی را اجرا می کند و خروجی اش را در فایل دیگری می نویسد
def export(entries_file_name,export_file_name,function):
    with open(entries_file_name,'r') as file:
        tmp_entries = file.readlines()
        entries = list()
        for entry in tmp_entries:
            entries.append(entry.replace('\n',''))
        file.close()

    with open(export_file_name,'w') as file:
        exports = list()
        counter = 0
        for entry in entries:
            entry = str(entry)

            if len(entries)-1 == counter:
                exports.append(str(function(entry)))
            else:
                exports.append(str(function(entry))+'\n')
            counter += 1
        file.writelines(exports)
        file.close()

export('input.txt','soal2.txt',solve)