# Coded By BitFire Team - All Rights Reserved
import string

# تابع پردازش اصلی - این تابع روی هر خط ورودی اجرا می شود
def solve(data: str):
    # تهیه دیکشنری، جهت تبدیل حرف به عدد متناظر آن در جدول حروف الفبا انگلیسی
    # مثال خروجی: {"a":1,"b":2,...,"z":26}
    letters = {}
    count = 1
    for letter in string.ascii_lowercase:
        letters[letter] = count
        count += 1

    # تهیه دیکشنری، جهت تبدیل عدد به حرف متناظر آن در جدول حروف الفبا انگلیسی
    # مثال خروجی: {1:"a",2:"b",...,26:"z"}
    letters_reversed = {}
    count = 1
    for letter in string.ascii_lowercase:
        letters_reversed[count] = letter
        count += 1

    # لیست اعداد حروف هر دسته
    root_letters = [1,4,9,16,25]                        # حروف ریشه دار
    incompleted_letters = [3,5,7,11,13,15,17,19,21,23]  # حروف ناتمام
    heavy_letters = [2,6,8,10,12,14,18,20,22,24,26]     # حروف سنگین
 
    text = data

    # بخش بندی خروجی نهایی به سه قسمت
    result_root = []         # بخش حروف ریشه دار
    result_incompleted = []  # بخش حروف ناتمام
    result_heavy = []        # بخش حروف سنگین

    text = text.lower()  # کوچک سازی حروف برای پردازش

    # دسته بندی حروف ورودی به سه دسته و قرار دادن عدد آن در دسته خروجی مربوطه
    for char in text:
        if letters[char] in root_letters:
            result_root.append(letters[char])
        elif letters[char] in incompleted_letters:
            result_incompleted.append(letters[char])
        elif letters[char] in heavy_letters:
            result_heavy.append(letters[char])

    # مرتب سازی اعداد حروف موجود در رشته ورودی در هر دسته، بر اساس معیار های مرتب سازی سوال
    result_root = sorted(result_root)                 # اعداد ریشه دار: از کوچک به بزرگ
    result_incompleted = sorted(result_incompleted)   # اعداد ناتمام: از کوچک به بزرگ
    result_heavy = sorted(result_heavy,reverse=True)  # اعداد سنگین: از بزرگ به کوچک
    
    # ایجاد خروجی با قرار دادن دسته ها در کنار یکدیگر به ترتیب
    output = ""
    for item in result_root:
        output += letters_reversed[item]
    for item in result_incompleted:
        output += letters_reversed[item]
    for item in result_heavy:
        output += letters_reversed[item]

    return output.upper()  # بازگرداندن خروجی به صورت حروف بزرگ

# تابع ایجاد خروجی - بر روی هر سطر ورودی، تابع اصلی را اجرا می کند و خروجی اش را در فایل دیگری می نویسد
def export(entries_file_name,export_file_name,function):
    with open(entries_file_name,'r') as file:
        tmp_entries = file.readlines()
        entries = list()
        for entry in tmp_entries:
            entries.append(entry.replace('\n',''))
        file.close()

    with open(export_file_name,'w') as file:
        exports = list()
        counter = 0
        for entry in entries:
            entry = str(entry)

            if len(entries)-1 == counter:
                exports.append(str(function(entry)))
            else:
                exports.append(str(function(entry))+'\n')
            counter += 1
        file.writelines(exports)
        file.close()

export('input.txt','soal3.txt',solve)
